#ifndef __MT_EDITOR_H__
#define __MT_EDITOR_H__

#include "MTWindow.h"
#include "MTUtilities.h"

class MTEditor : public MTWindow
{
	public:
				MTEditor();
		virtual	~MTEditor();
		
		void	SetBasePtr(void * inBasePtr)	{ basePtr = inBasePtr; ReadEditorData(); }
		void	SetVariant(UInt32 inVariant)	{ variant = inVariant; }
		void	SetTitle(std::string * inTitle)	{ title = inTitle; }
		
		void	HandleOpenEvent(void);
		void	HandleCloseEvent(void);
		void	HandleContentEvent(EventRecord * theEvent, UInt32 flags);
		void	HandleResizeEvent(SInt32 newWidth, SInt32 newHeight);
		void	HandleUpdateEvent(void);
		
		void	HandleScrollEvent(MTWindowControlType which, SInt32 value);
		void	HandleControlEvent(ControlHandle theControl, SInt16 thePart);
		void	HandleButtonEvent(ControlHandle theControl);
		void	HandleKeyEvent(EventRecord * theEvent, UInt8 charCode, UInt8 keyCode, EventModifiers modifiers);
		
		void	GetZoomSizeBounds(Rect * bounds);
		UInt8	IsUniqueWindow(void)	{ return 0; }
		
		MTWindowType	GetBaseWindowType(void)	{ return kEditorWindowType; }
		
		void	GetWindowName(StringPtr theString);
		
		void	RecieveMessage(UInt32 messageType, UInt32 messageData);
		UInt8	SupportsMessage(UInt32 messageType, UInt32 messageData);
	
	protected:
		short	GetWindowType(void)	{ return kWindowDocumentProc; }
		void	GetWindowSize(Rect * theRect);
		void	GetWindowStandardSize(Rect * theRect);
		void	GetWindowContentPadding(Rect * theRect);
		
		void	SetIsDirty(UInt8 inIsDirty)	{ isDirty = inIsDirty; }
		void	SetDirty(void)				{ isDirty = 1; }
		void	ClearDirty(void)			{ isDirty = 0; }
		UInt8	IsDirty(void)				{ return isDirty; }
		
		virtual void	CreateEditorControls(void) = 0;
		virtual void	DestroyEditorControls(void)	{ };
		virtual void	HandleEditorControls(ControlHandle theControl, SInt16 thePart);
		virtual void	UpdateEditorControls(void) { };
		
		virtual void	ReadEditorData(void) = 0;
		virtual void	WriteEditorData(void) = 0;
		
		void		* basePtr;
		std::string	* title;
		UInt32		variant;
	
	private:
		ControlHandle	okControl, cancelControl, titleControl;
		
		UInt8	isDirty;
};

#endif /* __MT_EDITOR_H__ */